{$Q+,R+}
{
    ACM ICPC 2003-2004 NEERC

    Problem:    Bring Them There
    Checker:    Andrew Stankevich
}

program checkb;

uses
    testlib, sysutils;

const
    maxn = 50;
    maxm = 200;
    maxk = 50;

var
    ja, pa, n, m, q, s, t, i, j, k, c, d, sh: longint;
    a: array [1..maxn, 1..maxn] of longint;
    pos: array [1..maxk] of longint;
    used: array [1..maxm] of boolean;
    moved: array [1..maxk] of boolean;


begin
    n := inf.readlongint;
    m := inf.readlongint;
    q := inf.readlongint;
    s := inf.readlongint;
    t := inf.readlongint;

    for i := 1 to m do
    begin
        j := inf.readlongint;
        k := inf.readlongint;
        a[j][k] := i;
        a[k][j] := i;
    end;

    ja := ans.readlongint;
    pa := ouf.readlongint;
    if pa > ja then
        quit(_wa, 'expected: ' + inttostr(ja) + ', found: ' + inttostr(pa));

    for i := 1 to q do
        pos[i] := s;

    for i := 1 to pa do
    begin
        for j := 1 to q do
            moved[j] := false;
        for j := 1 to m do
            used[j] := false;

        c := ouf.readlongint;
        if (c < 1) or (c > q) then
            quit(_wa, 'invalid number of ships moving: ' + inttostr(c));
        for j := 1 to c do
        begin
            sh := ouf.readlongint;
            if (sh < 1) or (sh > q) then
                quit(_wa, 'invalid ship number: ' + inttostr(sh));

            if moved[sh] then quit(_wa, 'day ' + inttostr(i) + ', ship ' + inttostr(sh) + ' moving twice');
            d := ouf.readlongint;
            if (d < 1) or (d > n) then
                quit(_wa, 'day ' + inttostr(i) + ', ship ' + inttostr(sh) + ', invalid destination star: ' + inttostr(d));
            if a[pos[sh]][d] = 0 then
                quit(_wa, 'day ' + inttostr(i) + ', ship ' + inttostr(sh) + ': no tunnel ' + inttostr(pos[sh]) + '->' + inttostr(d));
            if used[a[pos[sh]][d]] then
                quit(_wa, 'day ' + inttostr(i) + ': tunnel ' + inttostr(pos[sh]) + '->' + inttostr(d) + ' used more than once');
            used[a[pos[sh]][d]] := true;
            pos[sh] := d;
            moved[sh] := true;
        end;
    end;

    for i := 1 to q do
        if pos[i] <> t then
            quit(_wa, 'ship ' + inttostr(i) + ' did not get to target star');

    if ja > pa then
        quit(_fail, 'expected: ' + inttostr(ja) + ', found: ' + inttostr(pa));

    quit(_ok, inttostr(ja) + ' days');
end.