/*
    ACM ICPC 2003-2004 NEERC

    Problem:    King's Quest
    Author:     Andrew Stankevich
    Solution:   Roman Elizarov
*/

import java.io.*;
import java.util.*;

public class b {
	// Input data
	// will renumber edges from 0 to n-1
	static int n;
	static int[][] g; // graph
	static int[] match; // matching
	static int[] back_match; // backwards

	// Solution data: girls are marked (visit starting from them) 
	// - unique edge in graph goes from girls to boys.
	static int num;
	static int visit_top;
	static int[] visit_num;
	static int[] visit_stack; 
	static int[] mark;
	static int[] component_no;
	static int component_cnt;
	static boolean[] instack;

	static void readInput() throws IOException {
		BufferedReader in = new BufferedReader(new FileReader("king.in"));
		n = Integer.parseInt(in.readLine().trim());
		g = new int[n][];
		for (int i = 0; i < n; i++) {
			StringTokenizer st = new StringTokenizer(in.readLine());
			int k = Integer.parseInt(st.nextToken());
			g[i] = new int[k];
			for (int j = 0; j < k; j++)
				g[i][j] = Integer.parseInt(st.nextToken()) - 1;
		}
		match = new int[n];
		back_match = new int[n];
		component_no = new int[n];
		StringTokenizer st = new StringTokenizer(in.readLine());
		for (int i = 0; i < n; i++) {
			match[i] = Integer.parseInt(st.nextToken()) - 1;
			back_match[match[i]] = i;
		}
		in.close();
	}

	static void solve() {
		visit_num = new int[n];
		visit_stack = new int[n];
		mark = new int[n];
		component_no = new int[n];
		instack = new boolean[n];
		for (int i = 0; i < n; i++)
			if (visit_num[i] == 0)
				visit(i);
	}

	static void visit(int i) {
		visit_num[i] = ++num;
		visit_stack[visit_top++] = i; // add to visit stack
		instack[i] = true;
		int j = back_match[i]; // corresponding boy
		mark[i] = num; // will compute mark - earliest upward or sideways encountered 
		for (int k = 0; k < g[j].length; k++) {
		 	int other = g[j][k]; // other girl
		 	if (other != i) {
		 		if (visit_num[other] == 0) {
		 			// was not visited yet
		 			visit(other);
		 			mark[i] = Math.min(mark[i], mark[other]);
				} else if (visit_num[other] < visit_num[i] && instack[other]) {
					// backward or sideways
					mark[i] = Math.min(mark[i], visit_num[other]);
				}
		 	}
		}
		if (mark[i] == visit_num[i]) {
			// component found
			component_cnt++;
			int x;
			do {
				x = visit_stack[--visit_top];
				component_no[x] = component_cnt;
				instack[x] = false;
			} while (x != i);
		}
	}

	static void writeOutput() throws IOException {
		PrintWriter out = new PrintWriter(new FileWriter("king.out"));
		int[] list = new int[n];
		for (int i = 0; i < n; i++) {
			int cnt = 0;
			for (int j = 0; j < g[i].length; j++) {
			        int one = match[i];
				int other = g[i][j];
				if (component_no[one] == component_no[other])
					list[cnt++] = other;
			}
			out.print(cnt);
			Arrays.sort(list, 0, cnt);
			for (int k = 0; k < cnt; k++)
				out.print(" " + (list[k] + 1));
			out.println();
		}
		out.close();
	}

	public static void main(String[] args) throws IOException {
		readInput();
		solve();
		writeOutput();
	}
}
